      include 'mpif.h'
      integer,parameter :: numdat=100
      integer::senddata(numdat),recvdata(numdat)
      integer::nprocs,myrank,ierr
c 
      call MPI_INIT(ierr)
      call MPI_COMM_RANK(MPI_COMM_WORLD,myrank,ierr)
      call MPI_COMM_SIZE(MPI_COMM_WORLD,nprocs,ierr)
c
      if(myrank.eq.0)then
        open(10,file='fort.10')
        read(10,*) senddata
      endif
c
      icount=(numdat-1)/nprocs+1
      call MPI_SCATTER(senddata,icount,MPI_INTEGER,
     &                 recvdata(icount*myrank+1),icount,
     &                 MPI_INTEGER,0,MPI_COMM_WORLD,ierr)
c
      isum=0
      do i=1,icount
        isum = isum + recvdata(icount*myrank+i)
      enddo
c
      write(6,*) myrank,';partial sum=',isum
      call MPI_FINALIZE(ierr)
      stop
      end
