PROJ_DIR = /sc/cmc/apl/DirectSolverSeminar/SX
PROJ_SRC = $(PROJ_DIR)/dissection/src
LIB_DIR_DISSECTION = $(PROJ_DIR)/lib
UNAME := $(shell uname -s)
# define BLAS MKL or ATLAS : be careful with no space after the name of variable
# QUAD specifies 128bit floating point arithmetic : DD_REAL by qd library
MAKE       = make -j 8
#
DEBUGFLAG  = #-C sopt
#
#CPP = /SX/opt/sxc++/rev103/bin/sxc++ -Pmulti
#CXX = /SX/opt/sxc++/rev103/bin/sxc++ -Pmulti -Cvopt -Tnoauto,used -Kgcc -Kexceptions  -gv -dir,debug
CXX = sxc++ -Pmulti -Cvopt -Tnoauto,used -Kstd=c++98 -Kexceptions  #-gv -dir,debug
CPP = sxc++ -Pmulti
LD  = $(CXX)
#QUAD = DD_REAL 
QUAD = SX_ACE
QUAD_FLAG = -D$(QUAD) -DNO_OCTRUPLE -DSX_ACE
LDOPT      = 
#
DISSECTION_INC =  $(PROJ_DIR)/include
METIS_INC =  $(PROJ_DIR)/include
SCOTCH_INC = $(PROJ_DIR)/include
QD_INC =     $(PROJ_DIR)/include
LIB_DIR_METIS = $(PROJ_DIR)/lib
LIB_DIR_SCOTCH = $(PROJ_DIR)/lib
LIB_DIR_QD =  $(PROJ_DIR)/lib
LINK_QD = #-L$(LIB_DIR_QD) -lqd
LDOPT      = $(DEBUGFLAG)
#
BLAS_DEF = -DSX_ACE_BLAS #-DBLAS_FORTRAN
SHARED_COMPILER = -lpthread -lm -lcblas -f90lib -lblas

#
CCFLAGS    = $(DEBUGFLAG) -I$(METIS_INC) -I$(SCOTCH_INC) $(BLAS_DEF) -I.. -I$(PROJ_SRC)/Compiler $(CCFLAGS_OMP) $(QUAD_FLAG) -I$(QD_INC) -DNO_TO_STRING -DPOSIX_THREADS
FFLAGS     = $(DEBUGFLAG) -I.. $(FFFLAGS_OMP) 
#
#LDOPT      = $(DEBUGFLAG) -shared 

DISSECT_LIB_DIR = $(PROJ_LIBDIR)

all: MM-Dissection

MM-Dissection: MM-Dissection.o
	$(LD) $(LDOPT) -o MM-Dissection MM-Dissection.o \
        -L$(LIB_DIR_DISSECTION) -lDissection \
        -L$(LIB_DIR_SCOTCH) -lscotch -lscotcherr \
        -L$(LIB_DIR_METIS) -lmetis \
        $(SHARED_COMPILER)

.cpp.o:
	@echo Compiling $<
	$(CXX) $(CCFLAGS) -I$(DISSECTION_INC) -I. -c $< -o $@

clean:
	@echo Cleaning the trash...
	rm -fr *~ *.o *.so *.mod core *.d *.dll $(DIRECTORY) \
        MM-Dissection MM-Dissection-quad MM-Dissection-double-quad
