#
CXX = sxc++ -Pmulti -Popenmp -Cvopt -Tnoauto,used -Kstd=c++98 -Kexceptions  #-gv -dir,debug
CPP = sxc++ -Pmulti
LD  = $(CXX)
#
PROJ_DIR = /sc/cmc/apl/DirectSolverSeminar/SX
METIS_INC =  $(PROJ_DIR)/include
SCOTCH_INC = $(PROJ_DIR)/include
LIB_DIR_METIS = $(PROJ_DIR)/lib
LIB_DIR_SCOTCH = $(PROJ_DIR)/lib
#
LIB_DIR_MUMPS = $(PROJ_DIR)/lib
LIB_DIR_MUMPS_SEQ = $(PROJ_DIR)/libseq
LDOPT      = $(DEBUGFLAG)
#
CCFLAGS    = $(DEBUGFLAG) -I$(METIS_INC) -I$(SCOTCH_INC) $(BLAS_DEF) -I../include $(CCFLAGS_OMP) 
FFLAGS     = $(DEBUGFLAG) -I.. $(FFFLAGS_OMP) 
#
#LDOPT      = $(DEBUGFLAG) -shared 

MM-MUMPS.o: MM-MUMPS.cpp
elapsed_time.o: elapsed_time.cpp
.cpp.o:
	$(CXX) $(CCFLAGS) -c $< -o $@

all: MM-MUMPS

MM-MUMPS: MM-MUMPS.o elapsed_time.o
	$(LD) $(LDOPT) -o MM-MUMPS \
        MM-MUMPS.o \
        elapsed_time.o \
        -L$(LIB_DIR_MUMPS) -ldmumps -lmumps_common -lpord \
        -L$(LIB_DIR_MUMPS_SEQ) -lmpiseq \
        -L$(LIB_DIR_SCOTCH) -lesmumps -lscotch -lscotcherr \
	-L$(LIB_DIR_METIS) -lmetis \
	-lpthread -lm -lcblas -f90lib -llapack -lblas

clean:
	@rm -fr *~ *.o *.so core *.d *.mod *.a *.i90

