#include <cstdlib>
#include <cstdio>
#include <list>

using namespace std;

extern "C" {
  void c_get_matrix_size(int *n, int *nnz, const char *string);
  void c_read_matrix_coo(int *nnz, int *ai, int *aj, double *av, const char *string);
  void c_read_matrix_csr(int *nrow, int *nnz, int *ptrow, int *indcol, double *av, const char *string);

}

template<typename T>
bool generate_CSR(std::list<int>* ind_cols_tmp, std::list<T>* val_tmp, 
		  int nrow, int *nnz, 
		  int *irow, int *jcol, T* val, bool symmetrize)
{
  bool flag_modified = false;
  const T zero(0.0);
  //  ind_cols_tmp = new std::list<int>[nrow];
  //  val_tmp = new std::list<T>[nrow];
  int nnz1 = *nnz;
  for (int i = 0; i < *nnz; i++) {
    const int ii = irow[i] - 1;  // Fortran -> C
    const int jj = jcol[i] - 1;  /// Fortran -> C 
    //    fprintf(stderr, "%d %d -> %d %d \n", i0, j0, ii, jj);
    if (ind_cols_tmp[ii].empty()) {
      ind_cols_tmp[ii].push_back(jj);
      val_tmp[ii].push_back(val[i]);
    }
    else {
      if (ind_cols_tmp[ii].back() < jj) {
	ind_cols_tmp[ii].push_back(jj);
	val_tmp[ii].push_back(val[i]);
      }
      else {
	std::list<int>::iterator it = ind_cols_tmp[ii].begin();
	typename std::list<T>::iterator iv = val_tmp[ii].begin();
	for ( ; it != ind_cols_tmp[ii].end(); ++it, ++iv) {
	  if (*it == jj) {
	    fprintf(stderr, "already exits? (%d %d)\n", ii, jj);
	      break;
	  }
	  if (*it > jj) {
	    ind_cols_tmp[ii].insert(it, jj);
	    val_tmp[ii].insert(iv, val[i]);
	    break;
	  }
	}
      }
    }
  }
  // symmetrize
  if (symmetrize) {
    for (int i = 0; i < nrow; i++) {
      for (std::list<int>::iterator jt = ind_cols_tmp[i].begin();
	   jt != ind_cols_tmp[i].end(); ++jt) {
	const int jj = (*jt);
	bool flag = false;
	for (std::list<int>::iterator it = ind_cols_tmp[jj].begin();
	      it != ind_cols_tmp[jj].end(); ++it) {
	  if ((*it) == i) {
	    flag = true;
	    break;
	  }
	}
	if (!flag) {
	  flag_modified = true;
	  if (ind_cols_tmp[jj].back() < i) {
	    ind_cols_tmp[jj].push_back(i);
	    val_tmp[jj].push_back(zero);
	    nnz1++;
	  }
	  else {
	    typename std::list<T>::iterator iv = val_tmp[jj].begin();
	    std::list<int>::iterator it = ind_cols_tmp[jj].begin();
	    for (; it != ind_cols_tmp[jj].end(); ++it, ++iv) {
	      if ((*it) > i) {
		ind_cols_tmp[jj].insert(it, i);
		val_tmp[jj].insert(iv, zero);
		nnz1++;
		break;
	      }
	    }
	  }
	} // if (!flag);
      }
    }
  }

  *nnz = nnz1;
  return flag_modified;
}

template
bool generate_CSR<double>(std::list<int>* ind_cols_tmp,
			  std::list<double>* val_tmp, 
			  int nrow, int *nnz, 
			  int *irow, int *jcol, double* val, bool symmetrize);

template<typename T>
void copy_CSR(int *indcols, int *ptrows, T* coefs, int nrow, 
	      std::list<int>* ind_cols_tmp, std::list<T>* val_tmp)
{
  const T zero(0.0);
  ptrows[0] = 0;
  for (int i = 0; i < nrow; i++) {
    int k;
    int itmp = ind_cols_tmp[i].size();

    k = ptrows[i];
    ptrows[i + 1] = ptrows[i] + itmp;

    std::list<int>::iterator it = ind_cols_tmp[i].begin();
    typename std::list<T>::iterator iv = val_tmp[i].begin();
    for ( ; it != ind_cols_tmp[i].end(); ++it, ++iv, k++) {
      indcols[k] = *it;
      coefs[k] = *iv;
    }
  } // loop : i
  // C -> Fortran 1-based index
  for (int i = 0; i < (nrow + 1); i++) {
    ptrows[i]++;
  }
  for (int k = 0; k < (ptrows[nrow] - 1); k++) { 
    indcols[k]++;
  }
}

template
void copy_CSR<double>(int *indcols, int *ptrows, double* coefs, int nrow, 
	      std::list<int>* ind_cols_tmp, std::list<double>* val_tmp);

void c_get_matrix_size(int *n, int *nnz, const char *string)
{
  char buf[256];
  int jtmp;
  FILE *fp;
  //  fprintf(stderr, "%s %d\n", string, strlen(string));
  if ((fp = fopen(string, "r")) == NULL) {
    fprintf(stderr, "fail to open %s\n", string);
  }
  fgets(buf, 256, fp);
    
  while (1) {
    fgets(buf, 256, fp);
    if (buf[0] != '%') {
      sscanf(buf, "%d %d %d", n, &jtmp, nnz);
      break;
    }
  }
}

void c_read_matrix_coo(int *nnz, int *ai, int *aj, double *av,
		       const char *string)
{
  int itmp, jtmp, nnz0;
  char buf[256];
  FILE *fp;
  
  if ((fp = fopen(string, "r")) == NULL) {
    fprintf(stderr, "fail to open %s\n", string);
  }
  fgets(buf, 256, fp);
    
  while (1) {
    fgets(buf, 256, fp);
    if (buf[0] != '%') {
      sscanf(buf, "%d %d %d", &itmp, &jtmp, &nnz0);
      break;
    }
  }
  if (nnz0 != *nnz) {
    fprintf(stderr, "%s %d : data size mismatch %d %d\n", __FILE__, __LINE__,
	    nnz0, *nnz);
  }
  for (int i = 0; i < nnz0; i++) {
    fscanf(fp, "%d %d %lf", &ai[i], &aj[i], &av[i]); // read lower
  }
}

void c_read_matrix_csr(int *nrow, int *nnz, int *ptrow, int *indcol, double *av,
		       const char *string)
{
  int *aai, *aaj;
  double *aav;
  aai = new int[*nnz];
  aaj = new int[*nnz];
  aav = new double[*nnz];
  c_read_matrix_coo(nnz, aai, aaj, aav, string);
  list<int>* ind_cols_tmp = new std::list<int>[*nrow];
  list<double> * val_tmp = new std::list<double>[*nrow];
  generate_CSR<double>(ind_cols_tmp, val_tmp, 
		       *nrow, nnz, 
		       aai, aaj, aav, false);
  copy_CSR<double>(indcol, ptrow, av, 
		   *nrow,
		   ind_cols_tmp, val_tmp);
  
  delete [] ind_cols_tmp;
  delete [] val_tmp;
  
}
