program main
  Use Iso_C_Binding
!$    USE OMP_LIB  
  implicit none
  interface
     subroutine get_matrix_size(n, nnz, string) bind(C, name='c_get_matrix_size')
       integer, intent(inout)::n
       integer, intent(inout)::nnz
       character string(*)
     end subroutine get_matrix_size
     subroutine read_matrix_coo(nnz, ai, aj, av, string) bind(C, name='c_read_matrix_coo')
       integer :: nnz
       integer, intent(inout)::ai(nnz)
       integer, intent(inout)::aj(nnz)
       real(8), intent(inout)::av(nnz)
       character string(*)
     end subroutine read_matrix_coo
     subroutine read_matrix_csr(nrow, nnz, ai, aj, av, string) bind(C, name='c_read_matrix_csr')
       integer :: nrow, nnz
       integer, intent(inout)::ai(nnz)
       integer, intent(inout)::aj(nnz)
       real(8), intent(inout)::av(nnz)
       character string(*)
     end subroutine read_matrix_csr

  end interface

  INCLUDE 'dmumps_struc.h'
  TYPE (DMUMPS_STRUC) mumps_par
  integer :: nrow,nnz,num_threads,iordering,ierr,i,k,nomp
  real(8) :: eps_pivot,null_thres
  real(8), allocatable :: x(:), y(:), w(:), z(:)
  real(8) :: norm0,norm1
  character(256) :: arg
  character(:,C_char), allocatable::cfname

  if (iargc() /= 5) stop
  call getarg(1, arg)
! convert fortran-string to C-string
  cfname=trim(arg)//C_null_char
  call getarg(2, arg)
  read(arg,*)iordering
  call getarg(3, arg)
  read(arg,*)num_threads
  call getarg(4, arg)
  read(arg,*)eps_pivot
  call getarg(5, arg)
  read(arg,*)null_thres

!$ call omp_set_dynamic(0)
!$ call omp_set_num_threads(num_threads)
!$    nomp = OMP_GET_MAX_THREADS()

  write(6,'(a,i3,a,e18.6,a,e18.6)')"num_threads=",num_threads,&
&                                  " eps_pivot=",eps_pivot,&
&                                  " null_thres=", null_thres
  call get_matrix_size(nrow, nnz,cfname)
  write(6,*)nrow,nnz
  
  mumps_par%JOB = -1
  mumps_par%SYM = 0
  mumps_par%PAR = 1
! copied from examples/c_example.c sequential version
  mumps_par%COMM = -987654  
  CALL DMUMPS(mumps_par)

! allocation of COO data should be later than creation of the MUMPS object
  mumps_par%N=nrow
  mumps_par%NZ=nnz
  allocate(mumps_par%IRN(nnz))
  allocate(mumps_par%JCN(nnz))
  allocate(mumps_par%A(nnz))
  allocate(mumps_par%rhs(nrow))
  allocate(x(nrow))
  allocate(y(nrow))
  allocate(z(nrow))
  allocate(w(nrow))
  call read_matrix_coo(nnz, mumps_par%IRN, mumps_par%JCN, mumps_par%A, cfname)
!
  mumps_par%JOB = 1  ! symbolic
  mumps_par%ICNTL(1) = 6
  mumps_par%ICNTL(2) = 6
  mumps_par%ICNTL(3) = 6
  mumps_par%ICNTL(4) = 2
  mumps_par%ICNTL(5) = 0
  mumps_par%ICNTL(7) = iordering ! 3 : SCOTCH, 5 :METIS
  mumps_par%ICNTL(13) = 1
  mumps_par%ICNTL(24) = 1
  CALL DMUMPS(mumps_par)

  mumps_par%JOB = 2  ! numeric
  mumps_par%ICNTL(8) = 0
  mumps_par%CNTL(1) = 1.0d-2
  mumps_par%CNTL(2) = -1.0d-8
  CALL DMUMPS(mumps_par)

  do i=1,nrow
     y(i)=mod(i,11)
  end do
  do i=1,nrow
     w(i)=0.d0
  end do
  do k=1,nnz
     w(mumps_par%IRN(k))=w(mumps_par%IRN(k))+mumps_par%A(k)*y(mumps_par%JCN(k))
  end do
  do i=1,nrow
     y(i)=0.d0
  end do
  do k=1,nnz
     y(mumps_par%IRN(k))=y(mumps_par%IRN(k))+mumps_par%A(k)*w(mumps_par%JCN(k))
  end do
! copy from RHS
  do i=1,nrow
     mumps_par%rhs(i)=y(i)
  end do
  mumps_par%JOB = 3
  mumps_par%NRHS = 1
  CALL DMUMPS(mumps_par)
  do i=1,nrow
     x(i)=mumps_par%rhs(i)
  end do
  norm0=0.d0
  norm1=0.d0
  do i=1,nrow
     norm0=norm0+w(i)*w(i)
     norm1=norm1+(x(i)-w(i))*(x(i)-w(i))
  end do
  write(6,'(a,e24.16,a,e24.16,a,e24.16)')"error    =",sqrt(norm1/norm0)," =", &
&                                        sqrt(norm1)," /",sqrt(norm0)
  do i=1,nrow
     w(i)=0.d0
  end do
  do k=1,nnz
     w(mumps_par%IRN(k))=w(mumps_par%IRN(k))+mumps_par%A(k)*x(mumps_par%JCN(k))
  end do
  norm0=0.d0
  norm1=0.d0
  do i=1,nrow
     norm0=norm0+y(i)*y(i)
     norm1=norm1+(y(i)-w(i))*(y(i)-w(i))
  end do
  write(6,'(a,e24.16,a,e24.16,a,e24.16)')"residual =",sqrt(norm1/norm0)," =", &
&                                         sqrt(norm1)," /",sqrt(norm0)
  mumps_par%JOB = -2
  CALL DMUMPS(mumps_par)
  
end program main
