include 'mkl_pardiso.f90'
program main
  use Iso_C_Binding
  implicit none
  interface
     subroutine get_matrix_size(n, nnz, string) bind(C, name='c_get_matrix_size')
       integer, intent(inout)::n
       integer, intent(inout)::nnz
       character string(*)
     end subroutine get_matrix_size
     subroutine read_matrix_coo(nnz, ai, aj, av, string) bind(C, name='c_read_matrix_coo')
       integer :: nnz
       integer, intent(inout)::ai(nnz)
       integer, intent(inout)::aj(nnz)
       real(8), intent(inout)::av(nnz)
       character string(*)
     end subroutine read_matrix_coo
     subroutine read_matrix_csr(nrow, nnz, ai, aj, av, string) bind(C, name='c_read_matrix_csr')
       integer :: nrow, nnz
       integer, intent(inout)::ai(nnz)
       integer, intent(inout)::aj(nnz)
       real(8), intent(inout)::av(nnz)
       character string(*)
     end subroutine read_matrix_csr

  end interface

  integer, allocatable :: ptrow(:)
  integer, allocatable :: indcol(:)
  real(8), allocatable :: coef(:)
  integer :: nrow,nnz,i,k
  character(256) :: arg
  character(:,C_char), allocatable::cfname
  integer num_threads,iperturb
!
  integer(8) :: pt(64)
  integer :: maxfct, mnum, mtype, phase, nrhs, error, msglvl,idumy
  integer :: iparm(64)
  real(8) :: ddumy,norm0, norm1
  integer(8), allocatable, dimension(:) :: perm
  real(8), allocatable, dimension(:) :: x,y,w

  if (iargc() /= 3) stop
  call getarg(1, arg)
! convert fortran-string to C-string
  cfname=trim(arg)//C_null_char
  call getarg(2, arg)
  read(arg,*)num_threads
  call getarg(3, arg)
  read(arg,*)iperturb
  write(6,'(a,i3,a,i3)')"num_threads=",num_threads," perturbation=",iperturb
  call get_matrix_size(nrow, nnz,cfname)
  write(6,'(a,i9,a,i9)')"nrow=",nrow," nnz=",nnz

  allocate(ptrow(nrow + 1))
  allocate(indcol(nnz))
  allocate(coef(nnz))
  call read_matrix_csr(nrow, nnz, ptrow, indcol, coef, cfname)
  allocate(x(nrow))
  allocate(y(nrow))
  allocate(w(nrow))
  allocate(perm(nrow))
  call mkl_set_num_threads(num_threads);
  phase=11
  iparm(6)=3
  iparm(8)=iperturb
  iparm(11)=1  ! enable scaling
  iparm(13)=1  ! enable weighted matching
  mtype=11     ! structurally symmetric
  maxfct=1
  mnum=1
  nrhs=1
  msglvl=1
  call pardiso(pt, maxfct, mnum, mtype, phase, &
&                nrow, coef, ptrow, indcol, perm, nrhs, &
&                iparm, msglvl, ddumy, ddumy, error)
  phase=22
  call pardiso(pt, maxfct, mnum, mtype, phase, &
&                nrow, coef, ptrow, indcol, perm, nrhs, &
&                iparm, msglvl, ddumy, ddumy, error)
  do i=1,nrow
     y(i)=mod(i,11)
  end do
  do i=1,nrow
     w(i)=0.d0
     do k=ptrow(i),ptrow(i+1)-1
        w(i)=w(i)+coef(k)*y(indcol(k))
     end do
  end do
  do i=1,nrow
     y(i)=0.d0
     do k=ptrow(i),ptrow(i+1)-1
        y(i)=y(i)+coef(k)*w(indcol(k))
     end do
  end do
  phase=33
  call pardiso(pt, maxfct, mnum, mtype, phase, &
&                nrow, coef, ptrow, indcol, perm, nrhs, &
&                iparm, msglvl, y, x, error)
  norm0=0.d0
  norm1=0.d0
  do i=1,nrow
     norm0=norm0+w(i)*w(i)
     norm1=norm1+(x(i)-w(i))*(x(i)-w(i))
  end do
  write(6,'(a,e24.16,a,e24.16,a,e24.16)')"error    =",sqrt(norm1/norm0)," =", &
&                                        sqrt(norm1)," /",sqrt(norm0)
  do i=1,nrow
     w(i)=0.d0
     do k=ptrow(i),ptrow(i+1)-1
        w(i)=w(i)+coef(k)*x(indcol(k))
     end do
  end do
  norm0=0.d0
  norm1=0.d0
  do i=1,nrow
     norm0=norm0+y(i)*y(i)
     norm1=norm1+(y(i)-w(i))*(y(i)-w(i))
  end do
  write(6,'(a,e24.16,a,e24.16,a,e24.16)')"residual =",sqrt(norm1/norm0)," =", &
&                                         sqrt(norm1)," /",sqrt(norm0)
  phase=-1
  call pardiso(pt, maxfct, mnum, mtype, phase, &
&                nrow, coef, ptrow, indcol, perm, nrhs, &
&                iparm, msglvl, y, x, error)
       
end program main
