LIB_DIR_MKL = /opt/intel/compilers_and_libraries_2017/linux/mkl/lib/intel64
# SHARED_COMPILER = -L$(LIB_DIR_MKL) -lmkl_intel_lp64 -lmkl_intel_thread -lmkl_core -liomp5 -lm
PROJ_DIR = /sc/cmc/apl/DirectSolverSeminar/VCC
INC_DIR_MUMPS = $(PROJ_DIR)/include
LIB_DIR_MUMPS = $(PROJ_DIR)/lib
LIB_DIR_MUMPS_SEQ = $(PROJ_DIR)/libseq
LIB_DIR_SCOTCH = $(PROJ_DIR)/lib
LIB_DIR_METIS = $(PROJ_DIR)/lib

CXX = icpc
CCFLAGS = -O3 -I$(INC_DIR_MUMPS) -DBLAS_MKL
LDCXX = $(CXX)
LDOPT = 
F90 = ifort -qopenmp
LDF90 = $(F90)
F90FLAGS = -O3 -I$(INC_DIR_MUMPS)

MM-MUMPS.o: MM-MUMPS.f90
	$(F90) $(F90FLAGS) -c $< -o $@

csr_reader.o: csr_reader.cpp

.cpp.o:
	$(CXX) $(CCFLAGS) -c $< -o $@

all: MM-MUMPS

MM-MUMPS: MM-MUMPS.o csr_reader.o
	$(LDF90) -o MM-MUMPS MM-MUMPS.o csr_reader.o \
         -Xlinker -rpath=$(LIB_DIR_MUMPS) -L$(LIB_DIR_MUMPS) -ldmumps -lmumps_common -lpord \
         -Xlinker -rpath=$(LIB_DIR_MUMPS_SEQ) -L$(LIB_DIR_MUMPS_SEQ) -lmpiseq \
         -Xlinker -rpath=$(LIB_DIR_SCOTCH) -L$(LIB_DIR_SCOTCH) -lesmumps -lscotch -lscotcherr -lscotcherrexit \
         -Xlinker -rpath=$(LIB_DIR_METIS)  -L$(LIB_DIR_METIS) -lmetis \
         -Xlinker -rpath=$(LIB_DIR_MKL) -L$(LIB_DIR_MKL) -lmkl_intel_lp64 -lmkl_intel_thread -lmkl_core -liomp5 \
         -lm -lrt -lstdc++

clean:
	@rm -fr *~ *.o *.so core *.d *.mod *.a *.i90

