#
CXX = icpc
CCFLAGS = -O3
LD = $(CXX)
F90 = ifort
LDF90 = ifort
F90FLAGS = -O3

#
LIB_DIR_MKL = /opt/intel/compilers_and_libraries_2017/linux/mkl/lib/intel64
INC_DIR_MKL = /opt/intel/compilers_and_libraries_2017/linux/mkl/include/
#
 
all: MM-Pardiso

MM-Pardiso.o: MM-Pardiso.f90
	$(F90) $(F90FLAGS) -c $< -o $@

csr_reader.o: csr_reader.cpp

.cpp.o:
	@echo Compiling $<
	$(CXX) $(CCFLAGS) -I$(INC_DIR_MKL) -I. -c $< -o $@

MM-Pardiso: MM-Pardiso.o csr_reader.o
	$(LDF90) -o MM-Pardiso MM-Pardiso.o csr_reader.o \
        -Xlinker -rpath=$(LIB_DIR_MKL) -L$(LIB_DIR_MKL) -lmkl_intel_lp64 -lmkl_intel_thread -lmkl_core -liomp5 \
        -lintlc -lsvml -lm -lrt -lstdc++ 

clean:
	@rm -fr *~ *.o *.so core *.d *.mod *.a *.i90 MM-Pardiso

