program main
  use Iso_C_Binding
  implicit none
  interface
     subroutine get_matrix_size(n, nnz, string) bind(C, name='c_get_matrix_size')
       integer, intent(inout)::n
       integer, intent(inout)::nnz
       character string(*)
     end subroutine get_matrix_size
     subroutine read_matrix_coo(nnz, ai, aj, av, string) bind(C, name='c_read_matrix_coo')
       integer :: nnz
       integer, intent(inout)::ai(nnz)
       integer, intent(inout)::aj(nnz)
       real(8), intent(inout)::av(nnz)
       character string(*)
     end subroutine read_matrix_coo
     subroutine read_matrix_csr(nrow, nnz, ai, aj, av, string) bind(C, name='c_read_matrix_csr')
       integer :: nrow, nnz
       integer, intent(inout)::ai(nnz)
       integer, intent(inout)::aj(nnz)
       real(8), intent(inout)::av(nnz)
       character string(*)
     end subroutine read_matrix_csr

  end interface

  integer, allocatable :: ptrow(:)
  integer, allocatable :: indcol(:)
  real(8), allocatable :: coef(:)
  integer :: nrow,nnz,i,k
  character(256) :: arg
  character(:,C_char), allocatable::cfname
  integer num_threads,iordering,n0
  real(8) :: eps_pivot,norm0,norm1
  !
  integer(4) :: dslv(2)
  integer :: threads, symmetric, real_or_cmplx,verbose
  integer :: indefinite, scaling, decomposer, level, minnode, proj, trans

  integer(8), allocatable, dimension(:) :: perm
  real(8), allocatable, dimension(:) :: x,y,w

  if (iargc() /= 4) stop
  call getarg(1, arg)
! convert fortran-string to C-string
  cfname=trim(arg)//C_null_char
  call getarg(2, arg)
  read(arg,*)iordering
  call getarg(3, arg)
  read(arg,*)num_threads
  call getarg(4, arg)
  read(arg,*)eps_pivot
  write(6,'(a,i3,a,i3,a,e18.6)')"num_threads=",num_threads," ordering=",iordering,&
&                       "eps_pivot=",eps_pivot
  call get_matrix_size(nrow, nnz,cfname)
  write(6,'(a,i9,a,i9)')"nrow=",nrow," nnz=",nnz

  allocate(ptrow(nrow + 1))
  allocate(indcol(nnz))
  allocate(coef(nnz))
  call read_matrix_csr(nrow, nnz, ptrow, indcol, coef, cfname)
! C-style 0-based index for Dissection
  do i=1,nrow+1
     ptrow(i)=ptrow(i)-1
  end do
  do k=1,nnz
     indcol(k)=indcol(k)-1
  end do
  allocate(x(nrow))
  allocate(y(nrow))
  allocate(w(nrow))
  allocate(perm(nrow))

  real_or_cmplx = 1
  verbose=1
  call diss_init(dslv, 0, real_or_cmplx, num_threads, verbose)
  symmetric=0
  call diss_s_fact(dslv, nrow, ptrow, indcol, symmetric, iordering)
  indefinite=1
  scaling=2
  call diss_n_fact(dslv, coef, scaling, eps_pivot, indefinite)
  call diss_get_kern_dim(dslv, n0)
  if (n0 > 0) then
     write(6,'(a,i3)')"matrix is singular with kernel dim=",n0
  endif
  do i=1,nrow
     y(i)=mod(i,11)
  end do
! fortran-style 1-based index
  do i=1,nrow+1
     ptrow(i)=ptrow(i)+1
  end do
  do k=1,nnz
     indcol(k)=indcol(k)+1
  end do
!  
  do i=1,nrow
     w(i)=0.d0
     do k=ptrow(i)+1,ptrow(i+1)-1
        w(i)=w(i)+coef(k)*y(indcol(k))
     end do
  end do
  if (n0 > 0) then
     call diss_project(dslv, w)
  end if  
  do i=1,nrow
     y(i)=0.d0
     do k=ptrow(i),ptrow(i+1)-1
        y(i)=y(i)+coef(k)*w(indcol(k))
     end do
  end do
  if (n0 > 0) then
     call diss_project(dslv, y)
  end if
! copy from RHS
  do i=1,nrow
     x(i)=y(i)
  end do
  proj=1
  trans=0
  call diss_solve_1(dslv, x, proj, trans)
!
  norm0=0.d0
  norm1=0.d0
  do i=1,nrow
     norm0=norm0+w(i)*w(i)
     norm1=norm1+(x(i)-w(i))*(x(i)-w(i))
  end do
  write(6,'(a,e24.16,a,e24.16,a,e24.16)')"error    =",sqrt(norm1/norm0)," =", &
&                                        sqrt(norm1)," /",sqrt(norm0)
  do i=1,nrow
     w(i)=0.d0
     do k=ptrow(i),ptrow(i+1)-1
        w(i)=w(i)+coef(k)*x(indcol(k))
     end do
  end do
  norm0=0.d0
  norm1=0.d0
  do i=1,nrow
     norm0=norm0+y(i)*y(i)
     norm1=norm1+(y(i)-w(i))*(y(i)-w(i))
  end do
  write(6,'(a,e24.16,a,e24.16,a,e24.16)')"residual =",sqrt(norm1/norm0)," =", &
&                                         sqrt(norm1)," /",sqrt(norm0)
  call diss_free(dslv)       
end program main
