  program vhcall_main
  use vhcall_fortran
  implicit none
  integer(8) :: vh,sym,ca
  integer :: ret

  integer,parameter :: ny=6
  integer,parameter :: nx=1000

  integer:: i
  real(8):: wrk_i(nx,ny)
  real(8):: wrk_o(nx,ny)
  real(8):: wrk_b(nx,ny)

  call random_number(wrk_b)
  call random_number(wrk_i)

!--- VE PROGRAM ------------------------------------------------------------!
  wrk_o=0.d0

  call ve_init(nx,ny,wrk_b)
  call ve_calc(wrk_i)
  call ve_out(wrk_o)

  open(11,file="result-ve.txt",form="formatted")
  do i=1,100
    write(11,100) wrk_o(i,1)
  end do

!--- VH PROGRAM ------------------------------------------------------------!
  wrk_o=0.d0

! (0) VHcall Start
  vh = fvhcall_install("./libvhcallvh.so")

! (1) vh_init
  sym = fvhcall_find(vh, "vh_init");
  ca = fvhcall_args_alloc()
  ret = fvhcall_args_set(ca, fvhcall_intent_in, 1, nx)
  ret = fvhcall_args_set(ca, fvhcall_intent_in, 2, ny)
  ret = fvhcall_args_set(ca, fvhcall_intent_in, 3, wrk_b)
  ret = fvhcall_invoke_with_args(sym, ca);

! (2) vh_calc
  sym = fvhcall_find(vh, "vh_calc");
  call fvhcall_args_clear(ca)
  ret = fvhcall_args_set(ca, fvhcall_intent_in, 1, wrk_i)
  ret = fvhcall_invoke_with_args(sym, ca);

! (3) vh_out
  sym = fvhcall_find(vh, "vh_out");
  call fvhcall_args_clear(ca)
  ret = fvhcall_args_set(ca, fvhcall_intent_out, 1, wrk_o)
  ret = fvhcall_invoke_with_args(sym, ca);

! (4) VHcall End
  call fvhcall_args_free(ca)
  ret = fvhcall_uninstall(vh)

  open(12,file="result-vh.txt",form="formatted")
  do i=1,100
    write(12,100) wrk_o(i,1)
  end do
!---------------------------------------------------------------!

 100 format(6(x,e15.8))


  stop
  end program
