      module param
      implicit none
      integer n,maxiter
      parameter(n=2047,maxiter=1000)
      end module

      program sample
      use param
      implicit none
      double precision a(n,n),b(n,n),c(n,n),sum,ap
!hpf$ distribute (*,block) :: a,b
      integer i,j,iter ! DO variables
      integer idxx(n),idxy(n),ix,iy ! index variables
      double precision t1,t2 ! for timing
      data ap/0.0d0/

      do i=1,n
        idxx(i) = n - i + 1
        idxy(i) = n - i + 1
      enddo
     
      do j=2,n-1
        do i=1,n
          b(i,j) = 1.0d0
          c(i,j) = 1.0d0
        enddo
      enddo
      call bound(b)
      call bound_nodist(c)

      call etime(t1)

      do iter=1,maxiter

! main loop
        do j=2,n-1
          do i=2,n-1
            ix = idxx(i)
            iy = idxy(j)
            a(i,j)=(b(i,j)+b(i-1,j)+b(i+1,j)+b(i,j-1)+b(i,j+1))
     &            *0.2d0*c(ix,iy)+ap
          enddo
        enddo

        do i=1,n
          a(1,i) = a(2,i)
          a(n,i) = a(n-1,i)
        enddo
        call bound(a)

!hpf$   independent, reduction(ap)
        do j=1,n
          do i=1,n
            ix = idxx(i)
            b(ix,j)=a(i,j)*c(i,j)
            ap = ap * a(i,j) 
          enddo
        enddo

      enddo

      sum = 0.0d0
      do j=1,n      
        do i=1,n
          sum = sum + a(i,j)
        enddo
      enddo
      call etime(t2)
      write(*,*)"Time=",t2-t1
      write(*,*)sum
      end

      subroutine bound(a)
      use param
      implicit none
      double precision a(n,n)
!hpf$ distribute (*,block) :: a
      integer i
      do i=1,n
!hpf$   on home(a(:,1)), local begin
        a(i,1) = a(i,2)
!hpf$   endon
!hpf$   on home(a(:,n)), local begin
        a(i,n) = a(i,n-1)
!hpf$   endon
      enddo
      return
      end

      subroutine bound_nodist(a)
      use param
      implicit none
      double precision a(n,n)
      integer i
      do i=1,n
        a(i,1) = a(i,2)
        a(i,n) = a(i,n-1)
      enddo
      return
      end
