Linux  R2.6.32-358.18.1.el6.x86_64 FORTRAN90/SX         Rev.482        Mon Jan 19 17:24:09 2015
FILE NAME: mat_tune0.f
PROGRAM NAME: _MAIN
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

    11  mul  (  10): Parallel routine generated : main_$1
    11  mul  (   1): Parallelized by PARDO.
    11  opt  (1592): Outer loop unrolled inside inner loop.
    12  vec  (   1): Vectorized loop.
    12  vec  (  29): ADB is used for array.: c
    12  vec  (  29): ADB is used for array.: b
    12  vec  (  29): ADB is used for array.: a
    25  mul  (  10): Parallel routine generated : main_$2
    25  mul  (   1): Parallelized by PARDO.
    26  opt  (1592): Outer loop unrolled inside inner loop.
    26  vec  (   1): Vectorized loop.
    26  vec  (  25): Work vectors are used. Size=16384byte
    26  vec  (  29): ADB is used for array.: c
    27  vec  (   1): Vectorized loop.
    27  vec  (  29): ADB is used for array.: a
    27  vec  (  29): ADB is used for array.: b
Linux  R2.6.32-358.18.1.el6.x86_64 FORTRAN90/SX         Rev.482        Mon Jan 19 17:24:09 2015
FILE NAME: mat_tune0.f
PROGRAM NAME: _MAIN
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  ! practice_6 (original)
     2  !
     3  !
     4        implicit real(8)(a-h,o-z)
     5        parameter ( n=2048, moda=0 )
     6        real(8) a(n+moda,n),b(n+moda,n)
     7        real(4) c(n+moda,n)
     8        real(4) etime,cp1(2),cp2(2),t1,t2
     9        real(8) flop,xgflops
    10  
    11        do j = 1,n
    12          do i = 1,n
    13            a(i,j) = 0.0d0
    14            b(i,j) = n+1-max(i,j)
    15            c(i,j) = n+1-max(i,j)
    16          enddo
    17        enddo
     .        call main_$1 (a, b, c)                                            
    18  
    19        write(6,50) 'matrix_size =',n,' p_name       |'
    20       &          //'  user(sec)|   moda       check'
    21     50 format(1x,a,i5/1x,a)
    22  
    23        t1=etime(cp1)
    24  !     call ftrace_region_begin('Main-loop')
    25        do j=1,n
    26          do k=1,n
    27            do i=1,n
    28              a(i,j)=a(i,j)+b(i,k)*c(k,j)
    29            end do
    30          end do
    31        end do
     .        call main_$2 (a, b, c)                                            
    32  !     call ftrace_region_end('Main-loop')
    33        t2=etime(cp2)
    34        t2=t2-t1
    35  
    36        flop=dble(n)*dble(n)*dble(n)*2.0d0
    37        xgflops=flop/t2*1.0d-9
    38  
    39        write(6,60) ' mat_tune0.f_ |',t2,moda,a(n,n)
    40     60 format(1x,a,f10.3,' |',i6,4x,d24.15)
    41        write(6,70) xgflops,' (GFlops)'
    42     70 format(f10.3,a)
    43  
    44        stop
    45        end
Linux  R2.6.32-358.18.1.el6.x86_64 FORTRAN90/SX         Rev.482        Mon Jan 19 17:24:09 2015
FILE NAME: mat_tune0.f
PROGRAM NAME: _MAIN
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     .        subroutine main_$1
     .  !cdir pardo for, nobarr = (entry,exit)                                  
     .  !cdir nodep                                                             
     .        do j = 1, 512                                                     
     .  !cdir    nodep                                                          
     .           do i = 1, 2048                                                 
     .              a(i,j*4-3) = 0.0000000000000000e+000                        
     .              a(i,j*4-2) = 0.0000000000000000e+000                        
     .              a(i,j*4-1) = 0.0000000000000000e+000                        
     .              a(i,j*4) = 0.0000000000000000e+000                          
     .              b(i,j*4-3) = dfloat(2049 - max(i,j*4 - 3))                  
     .              b(i,j*4-2) = dfloat(2049 - max(i,j*4 - 2))                  
     .              b(i,j*4-1) = dfloat(2049 - max(i,j*4 - 1))                  
     .              b(i,j*4) = dfloat(2049 - max(i,j*4))                        
     .              c(i,j*4-3) = float(2049 - max(i,j*4 - 3))                   
     .              c(i,j*4-2) = float(2049 - max(i,j*4 - 2))                   
     .              c(i,j*4-1) = float(2049 - max(i,j*4 - 1))                   
     .              c(i,j*4) = float(2049 - max(i,j*4))                         
     .           enddo                                                          
     .        enddo                                                             
     .        end
Linux  R2.6.32-358.18.1.el6.x86_64 FORTRAN90/SX         Rev.482        Mon Jan 19 17:24:09 2015
FILE NAME: mat_tune0.f
PROGRAM NAME: _MAIN
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     .        subroutine main_$2
     .  !cdir pardo for, nobarr = (entry,exit)                                  
     .  !cdir nodep                                                             
     .        do j = 1, 2048                                                    
     .           do k = 1, 512                                                  
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(a,b)                                                 
     .              do i = 1, 2048                                              
     .                 a(i,j) = a(i,j) + b(i,(k-1)*4+1)*dble(c((k-1)*4+1,j)) + b
     .       1            (i,(k-1)*4+2)*dble(c((k-1)*4+2,j)) + b(i,(k-1)*4+3)*  
     .       2            dble(c((k-1)*4+3,j)) + b(i,(k-1)*4+4)*dble(c((k-1)*4+4
     .       3            ,j))                                                  
     .              enddo                                                       
     .           enddo                                                          
     .        enddo                                                             
     .        end
Linux  R2.6.32-358.18.1.el6.x86_64 FORTRAN90/SX         Rev.482        Mon Jan 19 17:24:09 2015
FILE NAME: mat_tune0.f
PROGRAM NAME: _MAIN
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             ! practice_6 (original)
     2:             !
     3:             !
     4:                   implicit real(8)(a-h,o-z)
     5:                   parameter ( n=2048, moda=0 )
     6:                   real(8) a(n+moda,n),b(n+moda,n)
     7:                   real(4) c(n+moda,n)
     8:                   real(4) etime,cp1(2),cp2(2),t1,t2
     9:                   real(8) flop,xgflops
    10:             
    11: P------>          do j = 1,n
    12: |V----->            do i = 1,n
    13: ||      A             a(i,j) = 0.0d0
    14: ||      A             b(i,j) = n+1-max(i,j)
    15: ||      A             c(i,j) = n+1-max(i,j)
    16: |V-----             enddo
    17: P------           enddo
    18:             
    19:                   write(6,50) 'matrix_size =',n,' p_name       |'
    20:                  &          //'  user(sec)|   moda       check'
    21:                50 format(1x,a,i5/1x,a)
    22:             
    23:                   t1=etime(cp1)
    24:             !     call ftrace_region_begin('Main-loop')
    25: P------>          do j=1,n
    26: |V----->            do k=1,n
    27: ||V---->              do i=1,n
    28: |||     A               a(i,j)=a(i,j)+b(i,k)*c(k,j)
    29: ||V----               end do
    30: |V-----             end do
    31: P------           end do
    32:             !     call ftrace_region_end('Main-loop')
    33:                   t2=etime(cp2)
    34:                   t2=t2-t1
    35:             
    36:                   flop=dble(n)*dble(n)*dble(n)*2.0d0
    37:                   xgflops=flop/t2*1.0d-9
    38:             
    39:                   write(6,60) ' mat_tune0.f_ |',t2,moda,a(n,n)
    40:                60 format(1x,a,f10.3,' |',i6,4x,d24.15)
    41:                   write(6,70) xgflops,' (GFlops)'
    42:                70 format(f10.3,a)
    43:             
    44:                   stop
    45:                   end
