
! I-J-K
! f95 -O1   mat_tune1_ijk.f

      implicit real(8)(a-h,o-z)
      parameter ( n=2048 , mod=0 )
      real(8) a(n+mod,n),b(n+mod,n)
      real(4) c(n+mod,n)
      real(4) etime,cp1(2),cp2(2),t1,t2
      real(8) flop,xgflops

      do j = 1,n
        do i = 1,n
          a(i,j) = 0.0d0
          b(i,j) = n+1-max(i,j)
          c(i,j) = n+1-max(i,j)
        enddo
      enddo

      write(6,50) 'matrix_size =',n,' p_name       |'
     &          //'  user(sec)|   mod       check'
   50 format(1x,a,i5/1x,a)

      t1=etime(cp1)

      do j=1,n
        do k=1,n
          do i=1,n
            a(i,j)=a(i,j)+b(i,k)*c(k,j)
          enddo
        enddo
      enddo

      t2=etime(cp2)
      t2=t2-t1

      flop=dble(n)*dble(n)*dble(n)*2.0d0
      xgflops=flop/t2*1.0d-9

      write(6,60) ' mat_tune1_ijk.f |',t2,mod,a(n,n)
   60 format(1x,a,f10.3,' |',i6,4x,d24.15)
      write(6,70) xgflops,' (GFlops)'
   70 format(f10.3,a)

      stop
      end

