      include 'mpif.h'
      integer,parameter :: numdat=100
      integer,allocatable :: idat(:),work(:)
      integer :: nprocs,myrank,ierr
      integer :: ist,ied
c 
      call MPI_INIT(ierr)
      call MPI_COMM_RANK(MPI_COMM_WORLD,myrank,ierr)
      call MPI_COMM_SIZE(MPI_COMM_WORLD,nprocs,ierr)
c
      ist = ((numdat-1)/nprocs+1)*myrank+1
      ied = ((numdat-1)/nprocs+1)*(myrank+1)
      allocate(idat(ist:ied))
      if(myrank.eq.0) then
        allocate(work(numdat))
        open(10,file='fort.10')
        read(10,*) work
      endif
      call MPI_SCATTER(work,ied-ist+1,MPI_INTEGER,
     +      idat(ist),ied-ist+1,MPI_INTEGER,0,MPI_COMM_WORLD,ierr)
      if(myrank.eq.0) deallocate(work)
c
      isum=0
      do i=ist,ied
        isum = isum + idat(i)
      enddo
c
      write(6,*) myrank,';partial sum=',isum
c
      call MPI_FINALIZE(ierr)
      stop
      end
