      program example6
      implicit real(8)(a-h,o-z)
      include 'mpif.h'
      integer ierr,myrank,nprocs,ist,ied
      parameter ( n=12000 )
      real(8) a(n,n),b(n,n),c(n,n)
      real(8) d(n,n)
      real(8) t1,t2
      call MPI_INIT(ierr)
      call MPI_COMM_SIZE(MPI_COMM_WORLD,nprocs,ierr)
      call MPI_COMM_RANK(MPI_COMM_WORLD,myrank,ierr)
      ist=((n-1)/nprocs+1)*myrank+1
      ied=((n-1)/nprocs+1)*(myrank+1)
      n2=n/nprocs
      do j = 1,n
        do i = 1,n
          a(i,j) = 0.0d0
          b(i,j) = n+1-max(i,j)
          c(i,j) = n+1-max(i,j)
        enddo
      enddo
      if(myrank.eq.0) then
      write(6,50) ' Matrix Size = ',n
      endif
   50 format(1x,a,i5)
      t1=MPI_WTIME()
      do j=ist,ied
        do k=1,n
          do i=1,n
            a(i,j)=a(i,j)+b(i,k)*c(k,j)
          end do
        end do
      end do
      call MPI_GATHER(a(1,ist),n*n2,MPI_REAL8,d,n*n2
     &               ,MPI_REAL8,0,MPI_COMM_WORLD, ierr)
      t2=MPI_WTIME()
      if(myrank.eq.0) then
      write(6,60) ' Execution Time = ',t2-t1,' sec',' A(n,n) = ',d(n,n)
      endif
   60 format(1x,a,f10.3,a,1x,a,d24.15)
      call MPI_FINALIZE(ierr)
      stop
      end
