Linux  R2.6.32-358.18.1.el6.x86_64 FORTRAN90/SX         Rev.501        Fri Jun  5 09:57:35 2015
FILE NAME: mat_tune0.f
PROGRAM NAME: _MAIN
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

    11  opt  (1592): 外側ループのアンローリングを行った。
    12  vec  (   1): ループ全体をベクトル化する。
    12  vec  (  29): 配列bに対して ADB を使用する。
    12  vec  (  29): 配列aに対して ADB を使用する。
    28  vec  (   1): ループ全体をベクトル化する。
    28  vec  (  29): 配列aに対して ADB を使用する。
    28  vec  (  29): 配列bに対して ADB を使用する。
Linux  R2.6.32-358.18.1.el6.x86_64 FORTRAN90/SX         Rev.501        Fri Jun  5 09:57:35 2015
FILE NAME: mat_tune0.f
PROGRAM NAME: _MAIN
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  ! practice_1 (original)
     2  !
     3  !
     4        implicit real(8)(a-h,o-z)
     5        parameter ( n=2048 , moda=0 )
     6        real(8) a(n+moda,n),b(n+moda,n)
     7        real(4) c(n+moda,n)
     8        real(4) etime,cp1(2),cp2(2),t1,t2
     9        real(8) flop,xgflops
    10  
    11        do j = 1,n
    12          do i = 1,n
    13            a(i,j) = 0.0d0
    14            b(i,j) = n+1-max(i,j)
    15            c(i,j) = n+1-max(i,j)
    16          enddo
    17        enddo
     .        do j = 1, 2048, 4                                                 
     .  !cdir    nodep                                                          
     .  !cdir    on_adb(a,b)                                                    
     .           do i = 1, 2048                                                 
     .              a(i,j) = 0.0000000000000000e+000                            
     .              a(i,j+1) = 0.0000000000000000e+000                          
     .              a(i,j+2) = 0.0000000000000000e+000                          
     .              a(i,j+3) = 0.0000000000000000e+000                          
     .              b(i,j) = dfloat(2049 - max(i,j))                            
     .              b(i,j+1) = dfloat(2049 - max(i,1 + j))                      
     .              b(i,j+2) = dfloat(2049 - max(i,2 + j))                      
     .              b(i,j+3) = dfloat(2049 - max(i,3 + j))                      
     .              c(i,j) = float(2049 - max(i,j))                             
     .              c(i,j+1) = float(2049 - max(i,1 + j))                       
     .              c(i,j+2) = float(2049 - max(i,2 + j))                       
     .              c(i,j+3) = float(2049 - max(i,3 + j))                       
     .           enddo                                                          
     .        enddo                                                             
    18  
    19        write(6,50) 'matrix_size =',n,' p_name       |'
    20       &          //'  user(sec)|   moda       check'
    21     50 format(1x,a,i5/1x,a)
    22  
    23        t1=etime(cp1)
    24  !     call ftrace_region_begin('Main-loop')
    25        do j=1,n
    26  !cdir nounroll
    27          do k=1,n
    28            do i=1,n
     .  !cdir nodep                                                             
     .  !cdir on_adb(a,b)                                                       
     .        do i = 1, 2048                                                    
    29              a(i,j)=a(i,j)+b(i,k)*c(k,j)
    30            end do
    31          end do
    32        end do
    33  !     call ftrace_region_end('Main-loop')
    34        t2=etime(cp2)
    35        t2=t2-t1
    36  
    37        flop=dble(n)*dble(n)*dble(n)*2.0d0
    38        xgflops=flop/t2*1.0d-9
    39  
    40        write(6,60) ' mat_tune0.f_ |',t2,moda,a(n,n)
    41     60 format(1x,a,f10.3,' |',i6,4x,d24.15)
    42        write(6,70) xgflops,' (GFlops)'
    43     70 format(f10.3,a)
    44  
    45        stop
    46        end
Linux  R2.6.32-358.18.1.el6.x86_64 FORTRAN90/SX         Rev.501        Fri Jun  5 09:57:35 2015
FILE NAME: mat_tune0.f
PROGRAM NAME: _MAIN
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             ! practice_1 (original)
     2:             !
     3:             !
     4:                   implicit real(8)(a-h,o-z)
     5:                   parameter ( n=2048 , moda=0 )
     6:                   real(8) a(n+moda,n),b(n+moda,n)
     7:                   real(4) c(n+moda,n)
     8:                   real(4) etime,cp1(2),cp2(2),t1,t2
     9:                   real(8) flop,xgflops
    10:             
    11: +------>          do j = 1,n
    12: |V----->            do i = 1,n
    13: ||      A             a(i,j) = 0.0d0
    14: ||      A             b(i,j) = n+1-max(i,j)
    15: ||                    c(i,j) = n+1-max(i,j)
    16: |V-----             enddo
    17: +------           enddo
    18:             
    19:                   write(6,50) 'matrix_size =',n,' p_name       |'
    20:                  &          //'  user(sec)|   moda       check'
    21:                50 format(1x,a,i5/1x,a)
    22:             
    23:                   t1=etime(cp1)
    24:             !     call ftrace_region_begin('Main-loop')
    25: +------>          do j=1,n
    26: |           !cdir nounroll
    27: |+----->            do k=1,n
    28: ||V---->              do i=1,n
    29: |||     A               a(i,j)=a(i,j)+b(i,k)*c(k,j)
    30: ||V----               end do
    31: |+-----             end do
    32: +------           end do
    33:             !     call ftrace_region_end('Main-loop')
    34:                   t2=etime(cp2)
    35:                   t2=t2-t1
    36:             
    37:                   flop=dble(n)*dble(n)*dble(n)*2.0d0
    38:                   xgflops=flop/t2*1.0d-9
    39:             
    40:                   write(6,60) ' mat_tune0.f_ |',t2,moda,a(n,n)
    41:                60 format(1x,a,f10.3,' |',i6,4x,d24.15)
    42:                   write(6,70) xgflops,' (GFlops)'
    43:                70 format(f10.3,a)
    44:             
    45:                   stop
    46:                   end
