module vh_module
  integer :: mx, my
  real(8),allocatable :: wrk(:,:)
end module vh_module
subroutine vh_init(nx,ny,buf)
  use vh_module
  implicit none
  integer,intent(in):: nx
  integer,intent(in):: ny
  real(8),intent(in):: buf(nx,ny)

  mx = nx
  my = ny

  allocate( wrk(mx,my) )
  wrk(1:mx,1:my) = buf(1:mx,1:my)

end subroutine vh_init
subroutine vh_out(wrk_o)
  use vh_module
  implicit none
  real(8),intent(out):: wrk_o(mx,my)

  wrk_o(1:mx,1:my) = wrk(1:mx,1:my)

end subroutine vh_out
subroutine vh_calc(wrk_i)
  use vh_module
  implicit none
  real(8),intent(in):: wrk_i(mx,my)
  integer :: i,j

  do j = 1,my
   do i = 1,mx
     wrk(i,j) = wrk(i,j) + wrk_i(i,j)
   end do
  end do

end subroutine vh_calc
